clear
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Run model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uncomment the two lines below if second simulation involves a different .mod file

dynare completemarkets    % model with no investment adjustment costs
save simulation1 dr_ ys_ lgy_ lgx_

% number of periods for IRFs.
nperiods = 100;

%%%% Make figure to compare simulation 1 and 2
load simulation1 
shock = [0    %merr
         0    %merr2
         0.01     %nerr
         0];  %nerr2
dset = 'f0';        
makeirf


titlelist = char('Output','Capital (next period)','Investment','Consumption','Saving Rate','Investment Rate');
legendlist = char('Home','Foreign');
figlabel = 'Responses to a 1% increase in productivity';
makechart(titlelist,legendlist,figlabel,...
          100*[f0_gdp_irf/f0_gdp, f0_kp_irf/f0_kp, f0_ip_irf/f0_ip, f0_cc_irf/f0_cc, f0_sy_irf,f0_ipy_irf],...
          100*[f0_gdp2_irf/f0_gdp2, f0_kp2_irf/f0_kp2, f0_ip2_irf/f0_ip2, f0_cc2_irf/f0_cc2, f0_sy2_irf, f0_ipy2_irf])

      
titlelist = char('Imports','Exports','RER Production Based','Trade Balance (share of GDP)','RER Consumption Based');
legendlist = char('Home','Foreign');
figlabel = 'Responses to a 1% increase in productivity';
makechart(titlelist,legendlist,figlabel,...
          100*[f0_ccm_irf/f0_ccm, f0_ccm2_irf/f0_ccm2, f0_pf_irf/f0_pf, f0_tby_irf,f0_q_irf/f0_q],...
          100*[f0_ccm2_irf/f0_ccm2, f0_ccm_irf/f0_ccm, f0_pf2_irf/f0_pf2, f0_tby2_irf,f0_q2_irf/f0_q2])
