// RBC model 
// with variable labor

var cc, le, lambda, gamma, gdp, ip, kp, rw, rk, n, m, ccd, ccm, pf, pc, tby, sy, ipy, q
    cc2, le2, lambda2, gamma2, gdp2, ip2 ,kp2, rw2, rk2, n2, m2, ccd2, ccm2, pf2, pc2, tby2, sy2, ipy2, q2;

varexo nerr, merr, nerr2, merr2;

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// % define parameters here
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

parameters beta_p, chi_p, le_p, delta_p, el, theta_p, 
           kpshr_p, nu_p, s_p, chi0_p, rhon_p, rhom_p, omega, rhoc;


// Discount factor  (default .99)
beta_p = 0.99;

// Frisch Elasticity of labor supply (2/chi_p);
chi_p = 10;

// Steady state labor supply
le_p = 0.5;

// depreciation rate (default 0.025)
delta_p = 0.025;

// elasticity of substitution between capital and labor
el = 0.95;
theta_p = 1/el;
 
// Capital share
kpshr_p = 0.3;

// Set nu so as to hit desired capital share
nu_p = (kpshr_p*(beta_p * delta_p - beta_p + 1)^(1/theta_p-1)*(beta_p)^(1-1/theta_p))^theta_p;

// saving rate
s_p = (nu_p/(delta_p-1+1/beta_p))^(1/theta_p)*(delta_p);  

// parameter determining labor supply in SS
chi0_p = (1-le_p)^(chi_p)*(1/(1-s_p))*(1/le_p)*(1-nu_p*((s_p/delta_p)^(1-theta_p)));

// weight of home produced goods in the consumption basket
omega = 0.80;

// elasticity of substitution between domestic and foreign goods
el =1000
rhoc = 1/(el-1);

rhon_p = 0.95;    
rhom_p = 0.95;
     
  
model;
///////////////////////////////////////////////////////////////////////////
// Country 1
///////////////////////////////////////////////////////////////////////////

// FOC with respect to consumption
1/cc - lambda*pc=0;   

// FOC wrt Labor
-chi0_p*(1-le)^(-chi_p) + lambda * rw =0;

// Lambda Marginal Utility of consumption
gamma-lambda = 0;

// gamma shadow price of capital
(1-delta_p)*beta_p * gamma(1) - gamma +beta_p *lambda(1)*rk(1) = 0;

// Aggregate Output
gdp = (nu_p*(kp(-1)*exp(m))^(1-theta_p) + (le*exp(n))^(1-theta_p))^(1/(1-theta_p));

// resource constraint
gdp = ccd + ip + ccm2;

// saving (share of gdp)
sy = (ip+pf*ip2)/2/gdp;

// Investment rate
ipy = ip/gdp;

// definition of consumption aggregator (pins down pc)
cc = (omega^(rhoc/(1+rhoc))*ccd^(1/(1+rhoc))+(1-omega)^(rhoc/(1+rhoc))*ccm^(1/(1+rhoc)))^(1+rhoc);

// domestic part of consumption demand
ccd = omega*(1/pc)^(-(1+rhoc)/rhoc) *cc;

// import demand
ccm = (1-omega)*(pf/pc)^(-(1+rhoc)/rhoc) * cc;

// consumption prices
//pc = (omega+(1-omega)*pf^(-1/rhoc))^(-rhoc);

// Trade Balance, share of GDP
tby = (ccm2-pf*ccm)/gdp;

// Risk-sharing condition
cc = q * cc2;

// Consumption-based real exchange rate
q = pf*pc2/pc;

// Capital
kp = (1-delta_p)*kp(-1) + ip;

// Rental Rate for Labor, FOC with respect to labor
rw = (gdp/(le*exp(n)))^(theta_p)*exp(n);

// Rental Rate for Capital
rk = nu_p*(gdp/(kp(-1)*exp(m)))^theta_p * exp(m);

// Labor-augmenting technology shock
n = rhon_p*n(-1) + nerr;

// Capital Augmenting Technology Shock
m = rhom_p*m(-1) + merr;

///////////////////////////////////////////////////////////////////////////
// Country 2
///////////////////////////////////////////////////////////////////////////

// FOC with respect to consumption
1/cc2 - lambda2*pc2=0;   

// FOC wrt Labor
-chi0_p*(1-le2)^(-chi_p) + lambda2 * rw2 =0;

// Lambda Marginal Utility of consumption
gamma2-lambda2 = 0;

// gamma shadow price of capital
(1-delta_p)*beta_p * gamma2(1) - gamma2 +beta_p *lambda2(1)*rk2(1) = 0;

// Aggregate Output
gdp2 = (nu_p*(kp2(-1)*exp(m2))^(1-theta_p) + (le2*exp(n2))^(1-theta_p))^(1/(1-theta_p));

// resource constraint
gdp2= ip2 + ccd2 + ccm;

// Saving Rate
sy2 = (ip2+pf2*ip)/gdp2/2;

// Investment rate
ipy2 = ip2/gdp2;

// definition of consumption aggregator (pins down ccd)
cc2 = (omega^(rhoc/(1+rhoc))*ccd2^(1/(1+rhoc))+(1-omega)^(rhoc/(1+rhoc))*ccm2^(1/(1+rhoc)))^(1+rhoc);

ccd2 = omega*(1/pc2)^(-(1+rhoc)/rhoc) *cc2;

// import demand
ccm2 = (1-omega)*(pf2/pc2)^(-(1+rhoc)/rhoc) * cc2;

//pc2 = (omega+(1-omega)*pf2^(-1/rhoc))^(-rhoc);

// Real exchange rate
pf2 = 1/pf;

// Consumption-based real exchange rate
q2 = 1/q;

// Trade Balance, share of GDP
tby2 = (ccm-pf2*ccm2)/gdp2;

// Capital
kp2 = (1-delta_p)*kp2(-1) + ip2;

// Rental Rate for Labor, FOC with respect to labor
rw2 = (gdp2/(le2*exp(n2)))^(theta_p)*exp(n2);

// Rental Rate for Capital
rk2 = nu_p*(gdp2/(kp2(-1)*exp(m2)))^theta_p * exp(m2);

// Labor-augmenting technology shock
n2 = rhon_p*n2(-1) + nerr2;

// Capital Augmenting Technology Shock
m2 = rhom_p*m2(-1) + merr2;

end;


// Steady state values

initval;

///////////////////////////////////////////////////////////////////////////
// Steady state for  country 1
///////////////////////////////////////////////////////////////////////////

// trade balance
tby = 0;

// Consumption-based real exchange rate
q=1;

// True saving
sy = s_p;

// Labor
le = le_p;

// Output
gdp = le_p*(1-nu_p*(s_p/(delta_p))^(1-theta_p))^(1/(theta_p-1));

// Investment
ip = (s_p * gdp);

// Investment rate
ipy = ip/gdp;

// Consumption
cc = (gdp - ip);

// domestic part of consumption
ccd = omega*cc;

// Import demand
ccm = (1-omega)*cc;

// Exchange rate
pf = 1;

// Consumption price
pc = 1;

// Capital 
kp = ip/delta_p;

// Rental rate for capital
rk = (delta_p - 1 + 1/beta_p);

// Rental rate for labor
rw = (gdp/le)^theta_p;

// Marginal utility of consumption
lambda = 1/cc;

// GAMMA: Marginal utility of capital
gamma = lambda;

// Labor-augmenting technology
n=0;

// Capital-augmenting technology
m=0;

///////////////////////////////////////////////////////////////////////////
// Steady state for country 2
///////////////////////////////////////////////////////////////////////////

// Trade balance
tby2 = 0;

// Real exchange rate
q2=1;

// True saving
sy2 = s_p;

// Labor
le2 = le_p;

// Output
gdp2 = le_p*(1-nu_p*(s_p/(delta_p))^(1-theta_p))^(1/(theta_p-1));

// Investment
ip2 = (s_p * gdp);

// Investment rate
ipy2 = ip2/gdp2;

// Consumption
cc2 = (gdp - ip);

// saving (share of gdp)
sy2 = 1-cc2/gdp2;

// domestic part of consumption
ccd2 = omega*cc2;

// Imports
ccm2 = (1-omega)*cc2;

// Real exchange rate
pf2 = 1;

// Consumption price
pc2 = 1;

// Capital 
kp2 = ip/delta_p;

// Rental rate for capital
rk2 = (delta_p - 1 + 1/beta_p);

// Rental rate for labor
rw2 = (gdp/le)^theta_p;

// Marginal utility of consumption
lambda2 = 1/cc2;

// GAMMA: Marginal utility of capital
gamma2 = lambda2;

// Labor-augmenting technology
n2=0;

// Capital-augmenting technology
m2=0;

end;

shocks;
var nerr; stderr .01;
var merr; stderr 0;
var merr2; stderr 0;
var nerr2; stderr .01;
end;

steady;

check;

stoch_simul(order=1,irf=0);

//stoch_simul(order=1,nocorr,nomoments,noprint,irf=0);
