clear
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Run model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% uncomment the two lines below if second simulation involves a different .mod file

dynare rbc0_95     % model with no investment adjustment costs
save simulation1 dr_ ys_ lgy_ lgx_

dynare rbc0_999
save simulation2 dr_ ys_ lgy_ lgx_

% number of periods for IRFs.
nperiods = 100;

%%%% Make figure to compare simulation 1 and 2
load simulation1 
shock = [0.01];
dset = 'f0';        
makeirf

load simulation2
shock =[0.01];
dset = 'f1';
makeirf

titlelist = char('Output','Capital (next period)','Investment','Consumption','Productivity');
legendlist = char('\rho = 0.95','\rho = 0.999');
figlabel = 'Responses to a 1% increase in productivity';

% makechart is a function that facilitates plotting.
% it sits in the plot_support subdirectory.
makechart(titlelist,legendlist,figlabel,...
          100*[f0_yv_irf/f0_yv, f0_kv_irf/f0_kv, f0_iv_irf/f0_iv, f0_cv_irf/f0_cv, f0_zv_irf],...
          100*[f1_yv_irf/f1_yv, f1_kv_irf/f1_kv, f1_iv_irf/f1_iv, f1_cv_irf/f1_cv, f1_zv_irf])

