// Canonical model
// specialized model. Calibration hits shares for ICT, Non-ICT, and Labor across sectors from in line with the Groningen data.
// The assembly functions are completely specialized. The output of the ICT sector is used only to produce ICT capital


// model's variables
var c, l, k_p, k_u, nk_p, nk_u, y, y_p, y_u, j,j_qa,j_p, c_p, c_u, t, u, v, isp, nisp
    lambda_c, lambda_l, l_p, l_u, lambda_kp, lambda_ku, lambda_nkp, lambda_nku, y_qa, c_qa_share, j_nqa
    j_u, nj_p, nj_u, lambda_j, nlambda_j, i_p, i_u,ni_p,ni_u, nj, lambda_y, p_u, mu_u, mu_p, z, au_rel_ap, j_qa_share, c_qa, juu,
    j_share_p, j_share_u, nj_share_p, nj_share_u, nj_share, j_share;

// innovations to shock processes
varexo err_isp, err_muu,err_mup,err_nisp,err_z;

// model's parameters
parameters rho_mup, rho_muu, rho_z,  zbar, lbar, beta, chi, cp, cu, delta, ndelta, eta, nu, gammaw
           gammap, sigmap, sigmau, niota, iota, ip, iu, nip, niu, mu, k2yp, kyp, k2yu, kyu, l2yp, lyp, l2yu, lyu, nk2yp, nkyp, nk2yu, nkyu, 
           sp, nsp, su, nsu, s, ns, ss, a, d, yp2y, yu2y, l2y, y2l, ybar, chi0;

// parameter values


param


model;
/////////////////////////////////////////////////////////////////
// First-order conditions with respect to all the multipliers
/////////////////////////////////////////////////////////////////

//1. C: Consumption
c = (cp *(c_p/cp) ^ ((gammap-1)/gammap) + cu * (c_u/cu * au_rel_ap) ^ ((gammap-1)/gammap)) ^ (gammap/(gammap-1));

//2_ L: Labor
l = l_p + l_u;

//3_ K_P: capital in sector p
k_p = (1-delta)*k_p(-1)/mu_p + isp*j_p * (1-nu/2*(j_p/j_p(-1)*mu_p - mu)^2);

//4_ K_U: capital in sector u
k_u = (1-delta)*k_u(-1)/mu_u + isp*j_u * (1-nu/2*(j_u/j_u(-1)*mu_u - mu)^2);

//5_ nk_p: 
nk_p = (1-ndelta)*nk_p(-1)/mu_p + nisp*nj_p * (1 - nu/2*(nj_p/nj_p(-1)*mu_p - mu)^2);

//6_ nk_u:
nk_u = (1-ndelta)*nk_u(-1)/mu_u + nisp*nj_u * (1 - nu/2*(nj_u/nj_u(-1)*mu_u - mu)^2);

//7_ y_p:
y_p = (   lyp *(l_p/lyp)^((sigmap - 1)/sigmap) 
        + kyp * (k_p(-1)/kyp/mu_p)^((sigmap-1)/sigmap) 
        + nkyp * (nk_p(-1)/nkyp/mu_p)^((sigmap-1)/sigmap) 
      ) ^ (sigmap/(sigmap-1));


//8_ y_u:      
y_u = (   lyu * (l_u/lyu)^((sigmau - 1)/sigmau)
        + kyu * (k_u(-1)/kyu/mu_u)^((sigmau - 1)/sigmau)
        + nkyu * (nk_u(-1)/nkyu/mu_u)^((sigmau-1)/sigmau)
       ) ^ (sigmau/(sigmau-1));

//9_ y:
y = y_p/p_u +  y_u * au_rel_ap;

//10_ j:       
j = ( ip*(i_p/ip)^((iota-1)/iota) + iu*(i_u/iu *au_rel_ap )^((iota-1)/iota) )^(iota/(iota-1));


//11_ nj:
nj = (nip*(ni_p/nip)^((niota-1)/niota) + niu*(ni_u/niu*au_rel_ap)^((niota-1)/niota))^(niota/(niota-1));

//12_ j_p:
j = j_p + j_u*au_rel_ap;

//13_ nj_p:
nj = nj_p + nj_u*au_rel_ap;

//14_ c_p:
y_p  = c_p + i_p + ni_p;

//15_ c_u:
y_u = c_u + i_u + ni_u;

//16_ t:
t = (c - eta*c(-1)/mu_p)/(1-eta);

//17_ u:
u = exp(chi0*((1-l)^(1-chi)-1)/((1-chi)*z));

//18_ v:
v = t*u;

//19_ lambda_c:
v^(-gammaw) / (1-eta) * u  - beta * eta /(1-eta) * u(1)*(mu_p(1)*v(1))^(-gammaw) = lambda_c;

//20_ lambda_l:
v^(1-gammaw) * (1-l)^(-chi)/z*chi0 = - lambda_l;


//21_ l_p: first order condition wrt l_p
lambda_l + lambda_y * ( lyp * y_p / l_p ) ^ (1/sigmap) = 0;

//22_ l_u: first order condition wrt l_u
lambda_l + lambda_y * p_u * (lyu * y_u/l_u) ^ (1/sigmau) * au_rel_ap = 0;


//23_ lambda_kp: foc wrt k_p
lambda_kp = beta*lambda_kp(1)*(1-delta)/mu_p(1)^gammaw 
           + beta*lambda_y(1)                      /mu_p(1)^gammaw       *(y_p(1)/k_p*kyp*mu_p(1))^(1/sigmap);

//24_ lambda_ku: foc wrt k_u
lambda_ku = beta*lambda_ku(1)*(1-delta)/mu_u(1)^gammaw 
            + beta*lambda_y(1)*au_rel_ap(1)^gammaw/mu_u(1)^gammaw *p_u(1)*(y_u(1)/k_u*kyu*mu_u(1))^(1/sigmau);  

//25_ lambda_nkp: foc wrt nk_p
lambda_nkp = beta*lambda_nkp(1)*(1-ndelta)/mu_p(1)^gammaw 
            + beta*lambda_y(1)                     /mu_p(1)^gammaw       *(y_p(1)/nk_p*nkyp*mu_p(1))^(1/sigmap);

//26_ lambda_nku: foc wrt nk_u
lambda_nku = beta*lambda_nku(1)*(1-ndelta)/mu_u(1)^gammaw   
            + beta*lambda_y(1)*au_rel_ap(1)^gammaw/mu_u(1)^gammaw *p_u(1)*(y_u(1)/nk_u*nkyu*mu_u(1))^(1/sigmau);

//27_ lambda_j: first order condition wrt j_p
        lambda_kp * (  isp* (1-nu/2*(j_p*mu_p/j_p(-1)-mu)^2) 
                      -nu * isp *(j_p*mu_p/j_p(-1)-mu) * j_p*mu_p/j_p(-1)
                    ) 
        + beta * lambda_kp(1)*isp(1)*mu_p(1)^(-gammaw)*nu*(j_p(1)*mu_p(1)/j_p - mu)*(j_p(1)*mu_p(1)/j_p)^2 
               
        = lambda_j ;

//28_ j_u: first order condition wrt j_u
        lambda_ku * (  isp * (1-nu/2*(j_u*mu_u/j_u(-1)-mu)^2) 
                      -nu * isp *(j_u*mu_u/j_u(-1)-mu) * j_u*mu_u/j_u(-1)
                    ) 
        + beta * lambda_ku(1)* isp(1)* mu_u(1)^(-gammaw)*nu*(j_u(1)*mu_u(1)/j_u - mu)*(j_u(1)*mu_u(1)/j_u)^2 
               
        = lambda_j*au_rel_ap^gammaw;

//29_ nj_p: foc wrt nj_p
         lambda_nkp * (   nisp *(1-nu/2*(nj_p*mu_p/nj_p(-1)-mu)^2) 
                      -nu * nisp* (nj_p*mu_p/nj_p(-1)-mu) * nj_p*mu_p/nj_p(-1)
                    ) 
        + beta * lambda_nkp(1)* nisp(1)* mu_p(1)^(-gammaw)*nu*(nj_p(1)*mu_p(1)/nj_p - mu)*(nj_p(1)*mu_p(1)/nj_p)^2 
               
        = nlambda_j ;

//30_ nj_u: foc wrt nj_u
         lambda_nku * (   nisp *(1-nu/2*(nj_u*mu_u/nj_u(-1)-mu)^2) 
                      -nu * nisp *(nj_u*mu_u/nj_u(-1)-mu) * nj_u*mu_u/nj_u(-1)
                    ) 
        + beta * lambda_nku(1)* nisp(1)* mu_u(1)^(-gammaw)*nu*(nj_u(1)*mu_u(1)/nj_u - mu)*(nj_u(1)*mu_u(1)/nj_u)^2 
               
        = nlambda_j*au_rel_ap^gammaw ;


//31_ i_p: foc wrt i_p
lambda_j * (j*ip/i_p)^(1/iota)- lambda_y = 0;

//32_ i_u: foc wrt i_u
lambda_j * (j*iu/i_u/au_rel_ap)^(1/iota) - lambda_y * p_u = 0; 

//33_ ni_p: foc wrt ni_p
nlambda_j * (nj*nip/ni_p)^(1/niota)- lambda_y = 0;

//34_ ni_u: foc wrt ni_u
nlambda_j * (nj*niu/ni_u/au_rel_ap)^(1/niota) - lambda_y * p_u = 0; 

//32_ lambda_y: foc wrt c_p
lambda_c * (cp * c/c_p)^(1/gammap) - lambda_y = 0;

//33_ p_u: foc wrt c_u
lambda_c * (cu * c/c_u/au_rel_ap)^(1/gammap) - lambda_y * p_u= 0;

//35_ mu_p:
log(mu_p) - log(mu) = rho_mup * (log(mu_p(-1)) - log(mu)) + err_mup;

//36_ mu_u:
log(mu_u) - log(mu) = rho_muu * (log(mu_u(-1)) - log(mu)) + err_muu;

//37_ z:
log(z) - log(zbar) = rho_z * (log(z(-1)) - log(zbar)) + err_z;

//38_ au_rel_ap:
au_rel_ap = au_rel_ap(-1)*mu_u/mu_p;

//39
log(isp) = log(isp(-1)) + err_isp;

//40
log(nisp) = log(nisp(-1))+err_nisp;

//
j_qa = isp*j+nisp*nj;

c_qa = c_p+c_u*au_rel_ap;

j_nqa = j+nj;

y_qa = j_qa + c_qa;

j_share_u = j_u/y_u;

nj_share_u = nj_u/y_u;

j_share_p = j_p/y_p;

nj_share_p = nj_p/y_p; 

j_share = j/y_qa;

nj_share = nj/y_qa;

j_qa_share = j_qa/y_qa;

c_qa_share = c_qa/y_qa;

juu = y-c;

end;

////////////////////////////////////////////////////////////////////
// STEADY STATES
////////////////////////////////////////////////////////////////////
initval;
// assumptions for initial steady state

isp = 1;
nisp =1;
au_rel_ap =1;
mu_u = mu;
mu_p = mu;
z = zbar;
p_u = 1;
l = lbar;
y = ybar;
y_p = yp2y*ybar;
y_u = yu2y*ybar;
l_p = l2yp*y_p;
l_u = l2yu*y_u;
k_p = k2yp*y_p;
k_u = k2yu*y_u;
nk_p = nk2yp*y_p;
nk_u = nk2yu*y_u;
c = (1-ss)*y;
c_u = cu*c;
c_p = cp*c;
j_p = (mu-1+delta)/mu*k_p;
j_u = (mu-1+delta)/mu*k_u;
nj_p = (mu-1+ndelta)/mu*nk_p;
nj_u = (mu-1+ndelta)/mu*nk_u;
j = s*y;
nj = ns*y;
i_u = iu*j;
i_p = ip*j;
ni_p = nip*nj;
ni_u = niu*nj;
t = (c - eta*c/mu_p)/(1-eta);
u = exp(chi0*((1-l)^(1-chi)-1)/((1-chi)*z));
v = t*u;
lambda_c = v^(-gammaw) / (1-eta) * u  - beta * (eta)/(1-eta) * u*v^(-gammaw)*mu_p^(-gammaw);
lambda_y = lambda_c;
lambda_l = - lambda_y;
lambda_kp = lambda_y ;
lambda_ku = lambda_y ;
lambda_nkp = lambda_y;
lambda_nku = lambda_y;
lambda_j = lambda_y;
nlambda_j = lambda_j;
j_qa = j+nj;
j_nqa = j+nj;
c_qa =c_p+c_u;
y_qa = j_qa + c_qa;
j_share_u = j_u/y_u;
j_share_p = j_p/y_p;
nj_share_u = nj_u/y_u;
nj_share_p = nj_p/y_p;
j_share = j/y_qa;
nj_share = nj/y_qa;
j_qa_share = j_qa/y_qa;
c_qa_share = c_qa/y_qa;
juu= y-c;

end;

shocks;
  var err_mup; stderr 0.01;
  var err_muu; stderr 0.01;
  var err_z; stderr 0.01;
end;


stoch_simul(order=1,nocorr,nomoments,noprint,irf=0);