// RBC model with fixed labor supply
// model's variables
var cv, kv, iv, yv, zv, lambdav, gammav;

// innovations to shock processes
varexo epsilonv;

// model's parameters
parameters deltap, betap, alphap, rhop;

// parameter values, call external file param
deltap = 0.025;
betap = 0.99;
alphap = 0.33;
rhop = 0.95;

zss = 0;
kss = (1/alphap*(1/betap-1+deltap))^(1/(alphap-1));
yss = kss^(alphap);
css = kss^alphap-deltap*kss;
iss = deltap*kss; 
lambdass = 1/css;
gammass = 1/css;

model;
/////////////////////////////////////////////////////////////////
// First-order conditions with respect to all the multipliers
/////////////////////////////////////////////////////////////////

// 1. foc with respect to c
lambdav = 1/cv;

// 2. foc with respect to k (remember that predetermined variables need to be lagged)
-betap*gammav(1)*alphap*exp(zv)*kv^(alphap-1) + gammav - betap*gammav(1)*(1-deltap) = 0;

// 3. foc with respect to i
lambdav = gammav;

// 4. law of motion for capital (remember that predetermined variables need to be lagged)
kv=(1-deltap)*kv(-1)+iv;

// 5. resource constraint
iv+cv = yv;

// 6. technology of production (remember that predetermined variables need to be lagged)
yv = exp(zv)*kv(-1)^alphap;

// 7. shock process
zv = rhop*zv(-1)+epsilonv;

end;

////////////////////////////////////////////////////////////////////
// STEADY STATES
////////////////////////////////////////////////////////////////////
initval;
// assumptions for initial steady state
yv = yss;
cv = css;
kv = kss;
iv = iss;
zv = 0;
lambdav = lambdass;
gammav = gammass;
end;

shocks;
  var epsilonv; stderr 0.01;
end;

stoch_simul(order=1,nocorr,nomoments,noprint,irf=0);